clear all
close all
clc

%
open('forze_fisso.fig');
a = get(gca,'Children');
x1 = get(a, 'XData');
y1 = get(a, 'YData');
close();
%
open('forze_bear_6.fig');
a = get(gca,'Children');
x2 = get(a, 'XData');
y2 = get(a, 'YData');
close();
% 
figure(1000)
% 
% Plot dei dati estratti dai due files ".fig" in un unico grafico 

plot(x1{2, :}, y1{2,:}, 'r', 'linewidth', 1.5); hold on
plot(x2{2, :}, y2{2,:}, '--r', 'linewidth', 1.5); 
plot(x1{1, :}, y1{1,:}, 'b', 'linewidth', 1.5); 
plot(x2{1, :}, y2{1,:}, '--b', 'linewidth', 1.5); hold off
legend('f_{x,ref}' ,'f_{x,bear}' ,'f_{y,ref}' ,'f_{y,bear}')
xlabel('\theta [deg]')
ylabel('Force [N]')

a = mean(y1{1,:}); b =  mean(y2{1,:});
c= mean(y1{2,:}); d = mean(y2{2,:});
[a, b, abs(a-b)/abs(a)*100 ]
[c, d, abs(c-d)/abs(c)*100]

%% 
open('pressione_fisso.fig');
a = get(gca,'Children');
x1 = get(a, 'XData');
y1 = get(a, 'YData');
close();
%
open('pressione_bear_6.fig');
a = get(gca,'Children');
x2 = get(a, 'XData');
y2 = get(a, 'YData');
close();
% 
figure(1000)
% 
% Plot dei dati estratti dai due files ".fig" in un unico grafico 
for ii =  1:size(x1, 1)
    plot(x1{ii,:},y1{ii,:}*1e-5, ':b', 'linewidth', 2)
    hold on
end
for ii =  1:size(x2, 1)
    plot(x2{ii,:},y2{ii,:}*1e-5, ':r', 'linewidth', 2)
    hold on
end
grid on
xlim([0, 210])
xlabel('Angular position [deg]')
ylabel('Pressure [bar]')

%% 
open('pressione_bear_wear_5.fig');
a = get(gca,'Children');
x1 = get(a, 'XData');
y1 = get(a, 'YData');
close();
%
open('pressione_bear_wear_0.fig');
a = get(gca,'Children');
x2 = get(a, 'XData');
y2 = get(a, 'YData');
close();
% 
figure(1000)
% 
% Plot dei dati estratti dai due files ".fig" in un unico grafico 
for ii =  1:size(x1, 1)
    plot(x1{ii,:},y1{ii,:}*1e-5, ':b', 'linewidth', 2)
    hold on
end
for ii =  1:size(x2, 1)
    plot(x2{ii,:},y2{ii,:}*1e-5, ':k', 'linewidth', 2)
    hold on
end
grid on
xlim([0, 210])
xlabel('Angular position [deg]')
ylabel('Pressure [bar]')